package com.yd.csf.feign.enums;

/**
 * 对账状态
 */
public enum ReconciliationStatusEnum {

    YY_SHZ("运营审核中","YY_SHZ","客户提交后的状态"),
    BS_DZZ("保司对账中","BS_DZZ","运营审核通过，提交给保司后"),
    BS_DZ_CG("保司对账成功","BS_DZ_CG","保司反馈，已经收到打款"),
    BS_DZ_SB("保司对账失败","BS_DZ_SB","保司反馈，没有收到打款"),
    ;

    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;
    //描述
    private String description;

    //构造函数
    ReconciliationStatusEnum(String itemLabel, String itemValue,String description) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
        this.description = description;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }

    public String getDescription() {
        return description;
    }
}
