package com.yd.csf.service.enums;

/**
 * 出账状态枚举
 */
public enum FortuneStatusEnum {

    //出账状态枚举
    WAIT("待出账", "0"),
    CAN_SEND("可出账, 待检核", "1"),
    CHECKED("可出账, 已检核", "4"),
    SENT("已出账", "2"),
    MATCH_FAIL("未找到当前预计发佣对应的来佣", "3"),

    ;
    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    FortuneStatusEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }
}
