package com.yd.csf.service.dto;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class PolicyReportData {
    // 基本信息
    private String startTime;
    private String endTime;
    private String location;
    private String serviceManager;

    // 保单详细信息
    private String policyHolder;
    private String policyNumber;
    private String insuranceCompany;
    private String insuredPerson;
    private String insurancePlan;
    private Integer insuredAge;
    private String currency;
    private Integer paymentPeriod;
    private BigDecimal annualAmount;
    private BigDecimal totalPrepayment;
    private BigDecimal premiumFee;

    // 附加险信息
    private List<AdditionalInsurance> additionalInsurances;

    @Data
    public static class AdditionalInsurance {
        private String name;
        private String paymentTerm;
        private String currency;
        private BigDecimal firstYearAmount;
    }
}
