package com.yd.csf.service.enums;

import org.apache.commons.lang3.ObjectUtils;

/**
 * 新单跟进状态枚举 'CHECKING'-'审核中','UNDERWRITING'-'承保中','FINISHED'-'已完成','DECLINED'-'已拒绝','CANCELLED'-'已取消'
 */
public enum PolicyFollowStatusEnum {
    FOLLOW_UP("待跟进", "FOLLOW_UP"),
    CHECKING("审核中", "CHECKING"),
    UNDERWRITING("承保中", "UNDERWRITING"),
    FINISHED("已完成", "FINISHED"),
    DECLINED("已拒绝", "DECLINED"),
    CANCELLED("已取消", "CANCELLED"),
    ;
    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    PolicyFollowStatusEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    /**
     * 根据 itemLabel 获取枚举
     *
     * @param itemLabel
     * @return
     */
    public static PolicyFollowStatusEnum getEnumByItemLabel(String itemLabel) {
        if (ObjectUtils.isEmpty(itemLabel)) {
            return null;
        }
        for (PolicyFollowStatusEnum anEnum : PolicyFollowStatusEnum.values()) {
            if (anEnum.itemLabel.equals(itemLabel)) {
                return anEnum;
            }
        }
        return null;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }
}
