package com.yd.csf.feign.fallback.insurant;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.insurant.ApiInsurantFeignClient;
import com.yd.csf.feign.dto.appointment.ApiInsurantInfoDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-受保人信息Feign降级处理
 */
@Slf4j
@Component
public class ApiInsurantFeignFallbackFactory implements FallbackFactory<ApiInsurantFeignClient> {
    @Override
    public ApiInsurantFeignClient create(Throwable cause) {
        return new ApiInsurantFeignClient() {
            @Override
            public Result edit(ApiInsurantInfoDto apiInsurantInfoDto) {
                return null;
            }

            @Override
            public Result<ApiInsurantInfoDto> detail(String appointmentBizId, String insurantBizId) {
                return null;
            }

        };
    }
}
