package com.yd.csf.feign.fallback.commissionsqltemplate;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.commissionsqltemplate.ApiCommissionSqlTemplateFeignClient;
import com.yd.csf.feign.request.commissionsqltemplate.ApiCommissionSqlTemplatePageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-SQL模板信息Feign降级处理
 */
@Slf4j
@Component
public class ApiCommissionSqlTemplateFeignFallbackFactory implements FallbackFactory<ApiCommissionSqlTemplateFeignClient> {
    @Override
    public ApiCommissionSqlTemplateFeignClient create(Throwable cause) {
        return new ApiCommissionSqlTemplateFeignClient() {
            @Override
            public Result page(ApiCommissionSqlTemplatePageRequest request) {
                return null;
            }
        };
    }
}
