package com.yd.csf.feign.response.policyreceipt;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiPolicyReceiptDetailResponse {

    //以下回执信息
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 保单回执表唯一业务ID
     */
    private String policyReceiptBizId;

    /**
     * 回执状态（CONFIRMED-已确认 UNCONFIRMED-未确认）
     */
    private String receiptStatus;

    /**
     * 回执日期
     */
    private LocalDateTime receiptDate;

    /**
     * 保单持有人签名（图片URL）
     */
    private String policyHolderSignature;

    /**
     * 保单持有人签名（图片URL）列表
     */
    private List<String> policyHolderSignatureList;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


    //以下保单信息
    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 保单受保人
     */
    private String insured;

    /**
     * 保单持有人（投保人）
     */
    private String policyHolder;

    /**
     * 保险公司名称
     */
    private String insuranceCompany;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 供款年期（字典）
     */
    private Integer paymentTerm;

    /**
     * 期交保费
     */
    private BigDecimal paymentPremium;

    /**
     * 保单币种
     */
    private String currency;
}
