package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.auth.core.dto.AuthUserDto;
import com.yd.csf.service.dto.*;
import com.yd.csf.service.model.Commission;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.model.CommissionCompareRecord;
import com.yd.csf.service.model.CommissionExpected;
import com.yd.csf.service.vo.CommissionStatisticsVO;
import com.yd.csf.service.vo.CommissionVO;

import java.util.List;

/**
* @author Zhang Jianan
* @description 针对表【commission(保单来佣表)】的数据库操作Service
* @createDate 2025-09-19 16:08:05
*/
public interface CommissionService extends IService<Commission> {

    QueryWrapper<Commission> getQueryWrapper(CommissionQueryRequest commissionQueryRequest);

    Page<CommissionVO> getCommissionVOPage(Page<Commission> commissionPage);

    List<CommissionVO> getCommissionList(List<Commission> commissionList);

    void fillCommissionList(List<Commission> commissionList);

    Boolean updateCommission(CommissionUpdateRequest commissionUpdateRequest);

    Boolean generateFortune(GenerateFortuneRequest generateFortuneRequest);

    Commission getByCommissionBizId(String commissionBizId);

    List<Commission> queryList(CommissionDto dto);

    List<CommissionBindPolicyBrokerDto> queryCommissionBindPolicyBrokerList(CommissionDto dto);

    CommissionStatisticsVO getCommissionStatistics(List<Long> commissionIds);

    CommissionExpected queryByCommission(String policyNo, String commissionName, Integer commissionPeriod, String currency, String premium);

    void validateCommissionUpdateRequest(CommissionUpdateRequest commissionUpdateRequest);

    void saveUpdateCommissionRecord(Commission commission, CommissionUpdateRequest commissionUpdateRequest, AuthUserDto currentLoginUser);

    void saveCompareRecord(Commission commission, CommissionExpected commissionExpected, AuthUserDto currentLoginUser);

    CommissionCompareRecord getNewCompareRecord(Commission existingCommission, CommissionExpected commissionExpected, AuthUserDto currentLoginUser);

    List<Commission> addCommissionBatch(List<CommissionAddRequest> customerAddRequestList);

    Boolean addToExpected(AddToExpectedCommissionRequest addToExpectedCommissionRequest);

    int updateStatusBatchById(List<Commission> existingCommissions);
}
