package com.yd.csf.service.vo;

import com.yd.csf.service.dto.PolicyFollowUpdateDto;
import com.yd.csf.service.dto.PolicyMailing;
import com.yd.csf.service.dto.VerifyPolicyInfo;
import com.yd.csf.service.enums.PolicyFollowStatusEnum;
import com.yd.csf.service.model.PolicyBroker;
import com.yd.csf.service.model.PolicyFollow;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.*;

/**
 * 新单跟进视图
 */
@Data
public class PolicyFollowVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 新单跟进唯一业务ID
     */
    @Schema(description = "新单跟进唯一业务ID")
    private String policyBizId;

    /**
     * 下一步跟进状态列表
     */
    @Schema(description = "下一步跟进状态列表, 下拉框")
    private Object nextStatusList;

    /**
     * 新单跟进Dto
     */
    @Schema(description = "新单跟进Dto")
    private PolicyFollowUpdateDto policyFollowUpdateDto;

    /**
     * 转介人
     */
    @Schema(description = "转介人")
    private List<PolicyBroker> brokerList;

    /**
     * 核保信息
     */
    @Schema(description = "核保信息")
    private VerifyPolicyInfo verifyPolicyInfo;

    /**
     * 保单邮寄
     */
    @Schema(description = "保单邮寄")
    private PolicyMailing policyMailing;

    /**
     * 保单信息
     */
//    private Policy policy;


    /**
     * 对象转封装类
     *
     * @param policyFollow
     * @return
     */
    public static PolicyFollowVO objToVo(PolicyFollow policyFollow) {
        if (policyFollow == null) {
            return null;
        }
        PolicyFollowVO policyFollowVO = new PolicyFollowVO();
        policyFollowVO.setPolicyBizId(policyFollow.getPolicyBizId());

        // 转换PolicyFollowUpdateDto
        PolicyFollowUpdateDto policyFollowUpdateDto = new PolicyFollowUpdateDto();
        BeanUtils.copyProperties(policyFollow, policyFollowUpdateDto);
        policyFollowVO.setPolicyFollowUpdateDto(policyFollowUpdateDto);

        // 处理 nextStatusList 字段
        Object nextStatusList = policyFollow.getNextStatusList();
        if (nextStatusList != null && !nextStatusList.toString().isEmpty()) {
            String[] statusArr = nextStatusList.toString().split(",");
            List<Map<String, String>> statusMapList = new ArrayList<>();
            for (String status : statusArr) {
                Map<String, String> map = new HashMap<>();
                map.put("itemLabel", PolicyFollowStatusEnum.getEnumByValue(status).getItemLabel());
                map.put("itemValue", status);
                statusMapList.add(map);
            }
            policyFollowVO.setNextStatusList(statusMapList);
        }

        VerifyPolicyInfo verifyPolicyInfo = new VerifyPolicyInfo();
        BeanUtils.copyProperties(policyFollow, verifyPolicyInfo);
        policyFollowVO.setVerifyPolicyInfo(verifyPolicyInfo);

        PolicyMailing policyMailing = new PolicyMailing();
        BeanUtils.copyProperties(policyFollow, policyMailing);
        policyFollowVO.setPolicyMailing(policyMailing);

        return policyFollowVO;
    }
}
