package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.feign.dto.conditionconfig.ApiRelObjectConditionDto;
import com.yd.csf.service.dto.RelObjectConditionDto;
import com.yd.csf.service.model.RelObjectCondition;
import com.yd.csf.service.dao.RelObjectConditionMapper;
import com.yd.csf.service.service.IRelObjectConditionService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 对象和规则条件配置关系表 - 配置所有相关的涉及到条件和计算公式的业务表条件规则 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Service
public class RelObjectConditionServiceImpl extends ServiceImpl<RelObjectConditionMapper, RelObjectCondition> implements IRelObjectConditionService {

    /**
     * 删除关系
     * @param dto
     * @return
     */
    @Override
    public Boolean del(ApiRelObjectConditionDto dto) {
        return this.remove(new LambdaQueryWrapper<RelObjectCondition>()
                .eq(StringUtils.isNotBlank(dto.getObjectBizId()),RelObjectCondition::getObjectBizId,dto.getObjectBizId())
        );
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<RelObjectCondition> queryList(RelObjectConditionDto dto) {
        List<RelObjectCondition> list = baseMapper.selectList(new LambdaQueryWrapper<RelObjectCondition>()
                .eq(StringUtils.isNotBlank(dto.getObjectBizId()),RelObjectCondition::getObjectBizId,dto.getObjectBizId())
        );
        return list;
    }

}
