package com.yd.csf.feign.request.premiumreconciliation;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class ApiPremiumReconciliationResultEditRequest {

    /**
     * 保费对账记录表唯一业务ID
     */
    @NotBlank(message = "保费对账记录表唯一业务ID不能为空")
    private String premiumReconciliationBizId;

    /**
     * 当次保司认定金额（客户当次缴纳的金额）
     */
    @NotNull(message = "当次保司认定金额不能为空")
    private BigDecimal recognizedAmount;

    /**
     * 当次保司认定币种
     */
    @NotNull(message = "当次保司认定币种不能为空")
    private String recognizedCurrency;

    /**
     * 当期剩余待付金额
     */
    @NotNull(message = "当期剩余待付金额不能为空")
    private BigDecimal remainingUnpaidAmount;

    /**
     * 当期剩余待付币种
     */
    @NotNull(message = "当期剩余待付币种不能为空")
    private String remainingUnpaidCurrency;


    //以下信息只有当前保单首期剩余待付金额为小于等于0时，才传入下面字段进行保单生效日和状态更新
    /**
     * 生效日期（保单生效日）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveDate;

    /**
     * 保单核保日
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date underwritingDate;

    /**
     * 保单状态
     */
    private String status;

}
