package com.yd.csf.feign.client.ruleItemconfig;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.ruleItemconfig.ApiRuleItemConfigFeignFallbackFactory;
import com.yd.csf.feign.request.ruleItemconfig.ApiRuleItemConfigAddRequest;
import com.yd.csf.feign.request.ruleItemconfig.ApiRuleItemConfigEditRequest;
import com.yd.csf.feign.request.ruleItemconfig.ApiRuleItemConfigPageRequest;
import com.yd.csf.feign.response.ruleItemconfig.ApiRuleItemConfigDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-基本法项目配置信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiRuleItemConfigFeignFallbackFactory.class)
public interface ApiRuleItemConfigFeignClient {

    /**
     * 分页查询-基本法项目配置信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiRuleItemConfigPageRequest request);

    /**
     * 详情-基本法项目配置信息
     * @param ruleItemBizId
     * @return
     */
    @GetMapping("/detail")
    Result<ApiRuleItemConfigDetailResponse> detail(@NotBlank(message = "基本法项目配置信息表唯一业务ID不能为空不能为空") @RequestParam(value = "ruleItemBizId") String ruleItemBizId);

    /**
     * 添加-基本法项目配置信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiRuleItemConfigAddRequest request);

    /**
     * 编辑-基本法项目配置信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiRuleItemConfigEditRequest request);

    /**
     * 删除-基本法项目配置信息 TODO
     * @param ruleItemBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "基本法项目配置信息表唯一业务ID不能为空不能为空") @RequestParam(value = "ruleItemBizId") String ruleItemBizId);
}
