package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class VerifyPolicyInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 保险种类
     */
    @Schema(description = "保险种类")
    private String productCate;

    /**
     * 递交日期
     */
    @Schema(description = "递交日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date submitDate;

    /**
     * 签单日期
     */
    @Schema(description = "签单日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 缮发日期
     */
    @Schema(description = "缮发日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date issueDate;

    /**
     * 保单生效日
     */
    @Schema(description = "保单生效日")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate;

    /**
     * 是否预缴: 0-否, 1-是
     */
    @Schema(description = "是否预缴: 0-否, 1-是")
    private Integer isPrepaid;

    /**
     * 预付额
     */
    @Schema(description = "预付额")
    private String prepaidAmount;

    /**
     * 折扣后预付额
     */
    @Schema(description = "折扣后预付额")
    private String prepaidAmountAfterDiscount;

    /**
     * 保单截止日期
     */
    @Schema(description = "保单截止日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date policyExpirationDate;

    /**
     * 缴费编号
     */
    @Schema(description = "缴费编号")
    private String paymentNumber;

}
