package com.yd.csf.feign.client.conditiontype;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.conditiontype.ApiConditionTypeFeignFallbackFactory;
import com.yd.csf.feign.request.conditiontype.ApiConditionTypeAddRequest;
import com.yd.csf.feign.request.conditiontype.ApiConditionTypeEditRequest;
import com.yd.csf.feign.request.conditiontype.ApiConditionTypePageRequest;
import com.yd.csf.feign.response.conditiontype.ApiConditionTypeDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-条件类型信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiConditionTypeFeignFallbackFactory.class)
public interface ApiConditionTypeFeignClient {

    /**
     * 分页查询-条件类型信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiConditionTypePageRequest request);

    /**
     * 详情-条件类型信息
     * @param conditionTypeBizId
     * @return
     */
    @GetMapping("/detail")
    Result<ApiConditionTypeDetailResponse> detail(@NotBlank(message = "条件类型信息表唯一业务ID不能为空不能为空") @RequestParam(value = "conditionTypeBizId") String conditionTypeBizId);

    /**
     * 添加-条件类型信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiConditionTypeAddRequest request);

    /**
     * 编辑-条件类型信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiConditionTypeEditRequest request);

    /**
     * 删除-条件类型信息 TODO
     * @param conditionTypeBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "条件类型信息表唯一业务ID不能为空不能为空") @RequestParam(value = "conditionTypeBizId") String conditionTypeBizId);
}
