package com.yd.csf.feign.client.conditionconfig;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.conditionconfig.ApiConditionConfigFeignFallbackFactory;
import com.yd.csf.feign.request.conditionconfig.ApiConditionConfigAddRequest;
import com.yd.csf.feign.request.conditionconfig.ApiConditionConfigEditRequest;
import com.yd.csf.feign.request.conditionconfig.ApiConditionConfigPageRequest;
import com.yd.csf.feign.response.conditionconfig.ApiConditionConfigDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-条件配置信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiConditionConfigFeignFallbackFactory.class)
public interface ApiConditionConfigFeignClient {

    /**
     * 分页查询-条件配置信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiConditionConfigPageRequest request);

    /**
     * 详情-条件配置信息
     * @param conditionBizId
     * @return
     */
    @GetMapping("/detail")
    Result<ApiConditionConfigDetailResponse> detail(@NotBlank(message = "条件配置信息表唯一业务ID不能为空不能为空") @RequestParam(value = "conditionBizId") String conditionBizId);

    /**
     * 添加-条件配置信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiConditionConfigAddRequest request);

    /**
     * 编辑-条件配置信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiConditionConfigEditRequest request);

    /**
     * 删除-条件配置信息 TODO
     * @param conditionBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "条件配置信息表唯一业务ID不能为空不能为空") @RequestParam(value = "conditionBizId") String conditionBizId);
}
