package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiApprovalService;
import com.yd.csf.feign.client.approval.ApiApprovalFeignClient;
import com.yd.csf.feign.request.approval.ApiApprovalClientUserPageRequest;
import com.yd.csf.feign.response.approval.ApiApprovalClientUserPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 审批信息
 *
 * @author zxm
 * @since 2025-10-21
 */
@RestController
@RequestMapping("/approval")
@Validated
public class ApiApprovalController implements ApiApprovalFeignClient {

    @Autowired
    private ApiApprovalService apiApprovalService;

    /**
     * 审批列表-客户端用户信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiApprovalClientUserPageResponse>> approvalClientUserPage(ApiApprovalClientUserPageRequest request) {
        return apiApprovalService.approvalClientUserPage(request);
    }
}
