package com.yd.csf.feign.fallback.expectedfortunelog;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.expectedfortunelog.ApiExpectedFortuneLogFeignClient;
import com.yd.csf.feign.request.expectedfortunelog.ApiExpectedFortuneLogPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-预计发佣日志记录信息Feign降级处理
 */
@Slf4j
@Component
public class ApiExpectedFortuneLogFeignFallbackFactory implements FallbackFactory<ApiExpectedFortuneLogFeignClient> {
    @Override
    public ApiExpectedFortuneLogFeignClient create(Throwable cause) {
        return new ApiExpectedFortuneLogFeignClient() {
            @Override
            public Result page(ApiExpectedFortuneLogPageRequest request) {
                return null;
            }
        };
    }
}
