package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class FortuneAddRequest implements Serializable {
    /**
     * 出账检核年月 yyyy-MM
     */
    @Schema(description = "出账检核年月 yyyy-MM")
    private String reconciliationYearMonth;

    /**
     * 应付款类型 R-关联保单应付款 U-非关联保单应付款
     */
    @Schema(description = "应付款类型 R-关联保单应付款 U-非关联保单应付款", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fortuneBizType;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 出账状态 0=待出账 1=可出帐，待检核 2=完成出账 3=部分出账 4=保留 5=已失效 6=可出帐，检核完成 7=未找到当前预计发佣对应的来佣
     */
    @Schema(description = "出账状态 0=待出账 1=可出帐，待检核 2=完成出账 3=部分出账 4=保留 5=已失效 6=可出帐，检核完成 7=未找到当前预计发佣对应的来佣, 字典值: csf_expected_fortune_status", requiredMode = Schema.RequiredMode.REQUIRED)
    private String status;

    /**
     * 出账期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "出账期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)", requiredMode = Schema.RequiredMode.REQUIRED)
    private Integer fortunePeriod;

    /**
     * 出账总期数
     */
    @Schema(description = "出账总期数")
    private Integer fortuneTotalPeriod;

    /**
     * 转介人
     */
    @Schema(description = "转介人", requiredMode = Schema.RequiredMode.REQUIRED)
    private String broker;

    /**
     * 转介人业务ID
     */
    @Schema(description = "转介人业务ID")
    private String brokerBizId;

    /**
     * 所属团队
     */
    @Schema(description = "所属团队", requiredMode = Schema.RequiredMode.REQUIRED)
    private String team;

    /**
     * 所属团队业务ID
     */
    @Schema(description = "所属团队业务ID")
    private String teamBizId;

    /**
     * 出账项目名称
     */
    @Schema(description = "出账项目名称", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fortuneName;

    /**
     * 出账项目类型
     */
    @Schema(description = "出账项目类型", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fortuneType;

    /**
     * 出账金额
     */
    @Schema(description = "出账金额", requiredMode = Schema.RequiredMode.REQUIRED)
    private BigDecimal amount;

    /**
     * 出账币种
     */
    @Schema(description = "出账币种", requiredMode = Schema.RequiredMode.REQUIRED)
    private String currency;

    /**
     * 出账日期
     */
    @Schema(description = "出账日期", requiredMode = Schema.RequiredMode.REQUIRED)
    private Date payoutDate;

    /**
     * 出账备注
     */
    @Schema(description = "出账备注")
    private String remark;

    private static final long serialVersionUID = 1L;
}
