package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.dto.RelObjectFormulaDto;
import com.yd.csf.service.model.RelObjectFormula;
import com.yd.csf.service.dao.RelObjectFormulaMapper;
import com.yd.csf.service.service.IRelObjectFormulaService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * <p>
 * 对象和公式配置关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Service
public class RelObjectFormulaServiceImpl extends ServiceImpl<RelObjectFormulaMapper, RelObjectFormula> implements IRelObjectFormulaService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<RelObjectFormula> queryList(RelObjectFormulaDto dto) {
        List<RelObjectFormula> list = baseMapper.selectList(new LambdaQueryWrapper<RelObjectFormula>()
                .eq(StringUtils.isNotBlank(dto.getObjectBizId()),RelObjectFormula::getObjectBizId,dto.getObjectBizId())
        );
        return list;
    }

    /**
     * 删除关系
     * @param dto
     * @return
     */
    @Override
    public Boolean del(RelObjectFormulaDto dto) {
        return this.remove(new LambdaQueryWrapper<RelObjectFormula>().eq(RelObjectFormula::getObjectBizId,dto.getObjectBizId()));
    }

}
