package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.dto.FormulaConfigDto;
import com.yd.csf.service.model.FormulaConfig;
import com.yd.csf.service.dao.FormulaConfigMapper;
import com.yd.csf.service.model.RuleItemConfig;
import com.yd.csf.service.service.IFormulaConfigService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 公式配置表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Service
public class FormulaConfigServiceImpl extends ServiceImpl<FormulaConfigMapper, FormulaConfig> implements IFormulaConfigService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<FormulaConfig> queryList(FormulaConfigDto dto) {
        List<FormulaConfig> list = baseMapper.selectList(new LambdaQueryWrapper<FormulaConfig>()
                .in(!CollectionUtils.isEmpty(dto.getFormulaBizIdList()),FormulaConfig::getFormulaBizId,dto.getFormulaBizIdList())
        );
        return list;
    }

}
