package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.dto.ConditionTypeDto;
import com.yd.csf.service.model.ConditionType;
import com.yd.csf.service.dao.ConditionTypeMapper;
import com.yd.csf.service.model.FormulaConfig;
import com.yd.csf.service.service.IConditionTypeService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 条件类型表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Service
public class ConditionTypeServiceImpl extends ServiceImpl<ConditionTypeMapper, ConditionType> implements IConditionTypeService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<ConditionType> queryList(ConditionTypeDto dto) {
        List<ConditionType> list = baseMapper.selectList(new LambdaQueryWrapper<ConditionType>()
                .in(!CollectionUtils.isEmpty(dto.getConditionTypeBizIdList()),ConditionType::getConditionTypeBizId,dto.getConditionTypeBizIdList())
        );
        return list;
    }
}
