package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 条件配置表
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Getter
@Setter
@TableName("condition_config")
public class ConditionConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 条件配置表唯一业务ID
     */
    @TableField("condition_biz_id")
    private String conditionBizId;

    /**
     * 条件类型表唯一业务ID
     */
    @TableField("condition_type_biz_id")
    private String conditionTypeBizId;

    /**
     * 条件编码
     */
    @TableField("code")
    private String code;

    /**
     * 条件名称
     */
    @TableField("name")
    private String name;

    /**
     * 条件描述
     */
    @TableField("description")
    private String description;

    /**
     * 最小值（在范围条件中表示最小值）
     */
    @TableField("min_value")
    private BigDecimal minValue;

    /**
     * 最大值（在范围条件中表示最大值）
     */
    @TableField("max_value")
    private BigDecimal maxValue;

    /**
     * 是否包含最小值（是否包含最小值，1表示包含，0表示不包含）
     */
    @TableField("include_min")
    private Boolean includeMin;

    /**
     * 是否包含最大值（是否包含最大值，1表示包含，0表示不包含）
     */
    @TableField("include_max")
    private Boolean includeMax;

    /**
     * 条件值（范围内的值）
     */
    @TableField("conditional_value")
    private String conditionalValue;

    /**
     * 优先级（数字越小优先级越高）
     */
    @TableField("priority")
    private Integer priority;

    /**
     * 显示顺序
     */
    @TableField("display_order")
    private Integer displayOrder;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Byte status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Boolean isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
