package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 基本法绑定表 - 存储基本法与业务员或团队的绑定关系，支持灵活的权限分配
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Getter
@Setter
@TableName("commission_rule_binding")
public class CommissionRuleBinding implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 基本法配置表唯一业务ID
     */
    @TableField("rule_biz_id")
    private String ruleBizId;

    /**
     * 基本法项目配置表唯一业务ID
     */
    @TableField("rule_item_biz_id")
    private String ruleItemBizId;

    /**
     * 绑定目标类型：AGENT-业务员, TEAM-团队
     */
    @TableField("target_type")
    private String targetType;

    /**
     * 目标ID，业务员ID或团队ID
     */
    @TableField("target_id")
    private String targetId;

    /**
     * 生效开始时间，绑定关系开始生效的时间
     */
    @TableField("effective_start")
    private LocalDateTime effectiveStart;

    /**
     * 生效结束时间，绑定关系失效的时间
     */
    @TableField("effective_end")
    private LocalDateTime effectiveEnd;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Boolean isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
