package com.yd.csf.api.service.impl;

import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiRelObjectFormulaService;
import com.yd.csf.feign.dto.formulaconfig.ApiFormulaConfigDto;
import com.yd.csf.feign.dto.formulaconfig.ApiRelObjectFormulaDto;
import com.yd.csf.service.dto.FormulaConfigDto;
import com.yd.csf.service.dto.RelObjectFormulaDto;
import com.yd.csf.service.model.FormulaConfig;
import com.yd.csf.service.model.RelObjectFormula;
import com.yd.csf.service.service.IFormulaConfigService;
import com.yd.csf.service.service.IRelObjectFormulaService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiRelObjectFormulaServiceImpl implements ApiRelObjectFormulaService {

    @Autowired
    private IRelObjectFormulaService iRelObjectFormulaService;

    @Autowired
    private IFormulaConfigService iFormulaConfigService;

    /**
     * 根据对象关系查询公式配置列表信息
     * @param dto
     * @return
     */
    @Override
    public Result<List<ApiFormulaConfigDto>> apiFormulaConfigDtoList(ApiRelObjectFormulaDto dto) {
        List<ApiFormulaConfigDto> apiFormulaConfigDtoList = new ArrayList<>();
        RelObjectFormulaDto relObjectFormulaDto = new RelObjectFormulaDto();
        BeanUtils.copyProperties(dto,relObjectFormulaDto);
        List<RelObjectFormula> relObjectFormulaList = iRelObjectFormulaService.queryList(relObjectFormulaDto);
        if (!CollectionUtils.isEmpty(relObjectFormulaList)) {
            List<String> formulaBizIdList = relObjectFormulaList.stream().map(RelObjectFormula::getFormulaBizId).collect(Collectors.toList());
            List<FormulaConfig> formulaConfigList = iFormulaConfigService.queryList(FormulaConfigDto.builder()
                    .formulaBizIdList(formulaBizIdList)
                    .build());
            if (!CollectionUtils.isEmpty(formulaConfigList)) {
                apiFormulaConfigDtoList = formulaConfigList.stream().map(d -> {
                    ApiFormulaConfigDto configDto = new ApiFormulaConfigDto();
                    BeanUtils.copyProperties(d,configDto);
                    return configDto;
                }).collect(Collectors.toList());
            }
        }
        return Result.success(apiFormulaConfigDtoList);
    }

    /**
     * 保存对象和公式配置关系
     * @param dto
     * @return
     */
    @Override
    public Result saveRelList(ApiRelObjectFormulaDto dto) {
        //先删后新增
        RelObjectFormulaDto relObjectFormulaDto = new RelObjectFormulaDto();
        BeanUtils.copyProperties(dto,relObjectFormulaDto);
        iRelObjectFormulaService.del(relObjectFormulaDto);

        //新增
        if (!CollectionUtils.isEmpty(dto.getFormulaBizIdList())) {
            List<RelObjectFormula> saveList = dto.getFormulaBizIdList().stream().map(bizId -> {
                RelObjectFormula relObjectFormula = new RelObjectFormula();
                BeanUtils.copyProperties(dto,relObjectFormula);
                relObjectFormula.setFormulaBizId(bizId);
                return relObjectFormula;
            }).collect(Collectors.toList());
            iRelObjectFormulaService.saveOrUpdateBatch(saveList);
        }
        return Result.success();
    }
}
