package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.policyreceipt.ApiPolicyReceiptPageRequest;
import com.yd.csf.feign.response.policyreceipt.ApiPolicyReceiptPageResponse;
import com.yd.csf.service.model.PolicyReceipt;
import com.yd.csf.service.dao.PolicyReceiptMapper;
import com.yd.csf.service.service.IPolicyReceiptService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 保单回执表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-25
 */
@Service
public class PolicyReceiptServiceImpl extends ServiceImpl<PolicyReceiptMapper, PolicyReceipt> implements IPolicyReceiptService {

    @Override
    public IPage<ApiPolicyReceiptPageResponse> page(Page<ApiPolicyReceiptPageResponse> page,
                                                    ApiPolicyReceiptPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param policyReceiptBizId
     * @return
     */
    @Override
    public PolicyReceipt queryOne(String policyReceiptBizId) {
        return this.getOne(new LambdaQueryWrapper<PolicyReceipt>().eq(PolicyReceipt::getPolicyReceiptBizId,policyReceiptBizId).last(" limit 1 "));
    }
}
