package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.dto.TaxationDto;
import com.yd.csf.service.model.Taxation;
import com.yd.csf.service.dao.TaxationMapper;
import com.yd.csf.service.service.ITaxationService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 税务信息表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-17
 */
@Service
public class TaxationServiceImpl extends ServiceImpl<TaxationMapper, Taxation> implements ITaxationService {

    @Override
    public Boolean delByObjectBizId(String objectBizId) {
        return this.remove(new LambdaQueryWrapper<Taxation>().eq(Taxation::getObjectBizId,objectBizId));
    }

    @Override
    public List<Taxation> queryList(TaxationDto dto) {
        return this.baseMapper.selectList(new LambdaQueryWrapper<Taxation>()
                .eq(Taxation::getObjectBizId,dto.getObjectBizId()));
    }


}
