package com.yd.csf.wx.feign.client.user;

import com.yd.common.result.Result;
import com.yd.csf.wx.feign.fallback.user.ApiUserFeignFactory;
import com.yd.csf.wx.feign.request.user.ApiApprovalAccountPageRequest;
import com.yd.csf.wx.feign.request.user.ApiApprovalAccountRequest;
import com.yd.csf.wx.feign.request.user.ApiUserImproveRequest;
import com.yd.csf.wx.feign.response.user.ApiUserDetailResponse;
import com.yd.csf.wx.feign.response.user.ApiUserImproveResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 香港保险小程序端服务-个人信息Feign客户端
 */
@FeignClient(name = "yd-csf-api",fallbackFactory = ApiUserFeignFactory.class)
public interface ApiUserFeignClient {

    /**
     * 完善信息
     * @param request
     * @return
     */
    @PostMapping("/improve")
    Result<ApiUserImproveResponse> userImprove(@Validated @RequestBody ApiUserImproveRequest request);

    /**
     * 审批账号列表查询
     * @param request
     * @return
     */
    @PostMapping("/referrer/approval/page")
    Result approvalAccountPage(@Validated @RequestBody ApiApprovalAccountPageRequest request);

    /**
     * 审批账号
     * @param request
     * @return
     */
    @PostMapping("/referrer/approval")
    Result approvalAccount(@Validated @RequestBody ApiApprovalAccountRequest request);

    /**
     * 当前登录客户端用户详情
     * @return
     */
    @GetMapping("/detail")
    Result<ApiUserDetailResponse> detail();

}
