package com.yd.auth;

import com.github.pagehelper.autoconfigure.PageHelperAutoConfiguration;
import com.yd.common.config.fegin.FeginConfig;
import com.yd.common.constant.WeServerNameConstants;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableAsync;

/**
 * 启动程序
 *
 */
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class, PageHelperAutoConfiguration.class})
@MapperScan("com.yd.**.mapper")
@EnableAsync
@EnableFeignClients(defaultConfiguration = FeginConfig.class)
public class AuthApplication {
    public static void main(String[] args) {
        new SpringApplicationBuilder(AuthApplication.class)
                .properties("spring.config.name:bootstrap", "config/bootstrap.yml")
                .properties("spring.application.name="+ WeServerNameConstants.ydAuth)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-auth启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
