package com.yd.auth.core.security;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Component
public class JwtAuthenticationEntryPoint implements AuthenticationEntryPoint {

    @Override
    public void commence(HttpServletRequest request, 
                         HttpServletResponse response,
                         AuthenticationException authException) throws IOException {

        // 设置响应类型为JSON
        response.setContentType("application/json;charset=UTF-8");
        // 直接设置401状态码
        response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
        // 返回JSON格式的错误信息
        response.getWriter().write("{\"code\":401,\"message\":\"未经授权的访问\"}");
    }
}
