package com.yd.common.utils;

import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.util.encoders.Hex;
import java.security.SecureRandom;
import java.util.Base64;

/**
 * SM3国密算法工具类
 */
public class SM3Util {

    // 生成盐值
    public static String generateSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return Base64.getEncoder().encodeToString(salt);
    }

    // SM3哈希计算
    public static String hash(String data) {
        SM3Digest digest = new SM3Digest();
        byte[] dataBytes = data.getBytes();
        digest.update(dataBytes, 0, dataBytes.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return Hex.toHexString(result);
    }

    // 带盐的SM3哈希
    public static String hashWithSalt(String data, String salt) {
        return hash(data + salt);
    }

    // 验证密码
    public static boolean verifyPassword(String inputPassword,
                                         String storedHash, String salt) {
        String hashedInput = hashWithSalt(inputPassword, salt);
        return hashedInput.equals(storedHash);
    }

    public static void main(String[] args) {
        // 1. 处理密码 - 使用SM3加盐哈希
        String password = "123456";

        String salt = SM3Util.generateSalt();
//        String salt = "hdcgRnNrvxNShm/VuNRqfA==";
        String hashedPassword = SM3Util.hashWithSalt(password, salt);
        //05c6ff03f779dd0fab34fb67c6c0be1c8cfb9a7cc241e86c23a8d9c05a8ea939
        System.out.println(hashedPassword);
    }
}
