package com.yd.common.enums;


/**
 * 返回码
 *
 * @author zxm
 */
public enum ResultCode {

    SUCCESS(200,"操作成功","") ,
    FAIL(500,"操作失败","") ,
    NULL_ERROR(201,"数据不存在","") ,
    TENANT_NAME_EXISTS(202,"租户名称已存在","") ,
    PARAM_CHECK_ERROR(4001,"参数校验异常",""),


    ;
    //返回码
    private final int code;
    //操作响应信息
    private final String message;
    //响应信息的详细描述
    private final String description;

    //构造函数
    ResultCode(int code, String message, String description) {
        this.code = code;
        this.message = message;
        this.description = description;
    }
    //get方法
    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public String getDescription() {
        return description;
    }
}
