package com.yd.auth.core.service.impl;

import com.yd.auth.core.dto.AuthUserDto;
import com.yd.user.service.model.SysUser;
import com.yd.user.service.service.ISysUserService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * authenticationManager.authenticate(authentication) -->进行spring security 登录认证
 * --> spring security 登录认证会走到这里去获取用户表的数据进行用户名和密码对比返回最后认证是否成功的结果
 */
@Service
public class AuthUserDetailsService implements UserDetailsService {

    @Autowired
    private ISysUserService iSysUserService;

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        //Spring Security用户认证对象
        AuthUserDto authUserDto = null;
        // 通过Feign调用yd-user-service服务获取用户信息
        SysUser sysUser = iSysUserService.queryOneByName(username);
        if (Objects.isNull(sysUser)) {
            throw new UsernameNotFoundException("用户不存在");
        }
        authUserDto = new AuthUserDto();
        BeanUtils.copyProperties(sysUser,authUserDto);

        // 查询用户角色 TODO
//        authUserDto.setRoles(roles);

        return authUserDto;
    }
}
