package com.yd.gateway;


import com.yd.common.constant.ServerNameConstants;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
 * 网关启动程序
 */
@SpringBootApplication(scanBasePackages = "com.yd")
@EnableFeignClients(basePackages = "com.yd")
public class GatewayApplication {
    public static void main(String[] args) {
        new SpringApplicationBuilder(GatewayApplication.class)
                .properties(
                        "spring.application.name=yd-gateway",
                        // 设置响应式模式，但不排除MVC
                        "spring.main.web-application-type=reactive",
                        "spring.main.allow-bean-definition-overriding=true",
                        "spring.main.allow-circular-references=true"
                )
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-gateway网关启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
