package com.yd.common.dto;

import com.yd.common.constant.CommonConstant;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class PageDto {

    private Integer pageNo = 1;

    private Integer pageSize = 10;

    /**
     * 排序字段
     */
    @Schema(description = "排序字段")
    private String sortField;

    /**
     * 排序顺序（默认降序）
     */
    @Schema(description = "排序顺序（默认降序, ascend-升序/descend-降序）")
    private String sortOrder = CommonConstant.SORT_ORDER_DESC;
}
