/*
 * Decompiled with CFR 0.152.
 */
package com.yd.auth.core.security;

import com.yd.auth.core.security.JwtAuthenticationToken;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class DummyAuthenticationManager
implements ReactiveAuthenticationManager {
    public Mono<Authentication> authenticate(Authentication authentication) {
        if (authentication instanceof JwtAuthenticationToken) {
            String token = (String)authentication.getCredentials();
            try {
                if (this.isValidToken(token)) {
                    String username = this.extractUsernameFromToken(token);
                    List<GrantedAuthority> authorities = this.extractAuthoritiesFromToken(token);
                    JwtAuthenticationToken authenticatedToken = new JwtAuthenticationToken(username, authorities);
                    authenticatedToken.setDetails(authentication.getDetails());
                    return null;
                }
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }
        return Mono.empty();
    }

    private boolean isValidToken(String token) {
        return token != null && !token.isEmpty();
    }

    private String extractUsernameFromToken(String token) {
        return "test-user";
    }

    private List<GrantedAuthority> extractAuthoritiesFromToken(String token) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_USER"));
        return authorities;
    }
}

