package com.yd.gateway;


import com.yd.common.constant.ServerNameConstants;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
 * 网关启动程序
 */
@SpringBootApplication(scanBasePackages = "com.yd")
@EnableFeignClients(basePackages = "com.yd")
public class GatewayApplication {
    public static void main(String[] args) {
        new SpringApplicationBuilder(GatewayApplication.class)
//                .properties("spring.config.name:bootstrap", "config/bootstrap.yml")
                .properties("spring.application.name="+ ServerNameConstants.ydGateway)
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-gateway网关启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
