package com.yd.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeMenuExample {
    public static void main(String[] args) {
        // 1. 创建菜单列表（模拟数据库查询结果）
        List<Menu> menuList = new ArrayList<>();
        menuList.add(new Menu(1L, 0L, "系统管理", 1, "/system", "system"));
        menuList.add(new Menu(2L, 1L, "用户管理", 1, "/system/user", "user"));
        menuList.add(new Menu(3L, 1L, "角色管理", 2, "/system/role", "peoples"));
        menuList.add(new Menu(4L, 0L, "监控管理", 2, "/monitor", "monitor"));
        menuList.add(new Menu(5L, 4L, "在线用户", 1, "/monitor/online", "online"));
        menuList.add(new Menu(6L, 4L, "系统日志", 2, "/monitor/log", "log"));
        menuList.add(new Menu(7L, 2L, "用户新增", 1, null, null));
        menuList.add(new Menu(8L, 2L, "用户编辑", 2, null, null));

        // 2. 构建树形结构
        List<Menu> treeMenu = TreeUtils.buildTree(
                menuList,
                Menu::getId,         // 获取节点ID
                Menu::getParentId,   // 获取父节点ID
                (parent, children) -> parent.setChildren(children), // 设置子节点
                0L                   // 根节点的父ID值
        );

        // 3. 打印树形结构
//        printTree(treeMenu, 0);
        
        // 4. 创建树形JSON
        List<Map<String, Object>> treeJson = TreeUtils.createTreeJson(
                treeMenu,
                Menu::getChildren,
                menu -> {
                    Map<String, Object> map = new HashMap<>();
                    map.put("id", menu.getId());
                    map.put("name", menu.getName());
                    map.put("path", menu.getPath());
                    map.put("icon", menu.getIcon());
                    return map;
                },
                "/"
        );

        System.out.println("\n树形JSON结构:");
        System.out.println(treeJson);
    }

    // 递归打印树形结构
    private static void printTree(List<Menu> menus, int level) {
        if (menus == null) return;

        for (Menu menu : menus) {
            for (int i = 0; i < level; i++) {
                System.out.print("  ");
            }
            System.out.println("├─ " + menu.getName() + " (ID: " + menu.getId() + ")");

            if (menu.getChildren() != null && !menu.getChildren().isEmpty()) {
                printTree(menu.getChildren(), level + 1);
            }
        }
    }
}
