package com.yd.auth.core.utils;

import com.yd.auth.core.dto.AuthUserDto;
import com.yd.common.exception.BusinessException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityUtil {

    /**
     * 获取当前登录用户信息
     * @return
     */
    public static AuthUserDto getCurrentLoginUser() {
        // 从 SecurityContext 获取认证信息
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new BusinessException("用户未登录!");
        }
        if (!(authentication.getPrincipal() instanceof AuthUserDto)) {
            throw new BusinessException("用户未登录!");
        }

        AuthUserDto currentUser = (AuthUserDto) authentication.getPrincipal();
        return currentUser;

    }
}
