package com.yd.common.utils;

import org.apache.commons.lang3.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;

public class DateUtil {

    public static String formatDate(Object date) {
        try {
            if (date == null) return "";
            if (date instanceof Date) {
                return new SimpleDateFormat("yyyy/MM/dd").format((Date) date);
            }
            return date.toString();
        }catch (Exception e) {
            return "";
        }
    }

    public static Date parseDate(String dateStr) {
        try {
            return new SimpleDateFormat("yyyy/MM/dd").parse(dateStr);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * localDateTime转成年/月/日这种格式
     * @param localDateTime
     * @return
     */
    public static String getyyyyMMdd(LocalDateTime localDateTime) {
        try {
            if (Objects.isNull(localDateTime)) {
                return "";
            }

            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
            return localDateTime.format(formatter);
        }catch (Exception e) {
            return "";
        }
    }

    /**
     * localDateTime转成时分这种格式
     * @param localDateTime
     * @return
     */
    public static String getHHmm(LocalDateTime localDateTime) {
        try {
            if (Objects.isNull(localDateTime)) {
                return "";
            }

            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
            return localDateTime.format(formatter);
        }catch (Exception e) {
            return "";
        }
    }

    /**
     * localDateTime转成年-月-日 时:分这种格式
     * @param localDateTime
     * @return
     */
    public static String getyyyyMMddHHmm(LocalDateTime localDateTime) {
        try {
            if (Objects.isNull(localDateTime)) {
                return "";
            }

            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            return localDateTime.format(formatter);
        }catch (Exception e) {
            return "";
        }
    }

    /**
     * yyyy/MM/dd HH:mm转成LocalDateTime
     * @param timeStr
     * @return
     */
    public static LocalDateTime getLocalDateTime(String timeStr) {
        try {
            if (StringUtils.isBlank(timeStr)) {
                return null;
            }

            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm");
            // 解析字符串为LocalDateTime
            LocalDateTime localDateTime = LocalDateTime.parse(timeStr, formatter);
            return localDateTime;
        }catch (Exception e) {
            return null;
        }
    }

    /**
     * yyyy/MM/dd 转成 LocalDateTime
     * @param timeStr
     * @return
     */
    public static LocalDateTime getYMDLocalDateTime(String timeStr) {
        try {
            if (StringUtils.isBlank(timeStr)) {
                return null;
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
            LocalDate localDate = LocalDate.parse(timeStr, formatter);
            return localDate.atStartOfDay(); // 转换为当天的开始时间 (00:00)
        } catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(getHHmm(LocalDateTime.now()));
    }

    /**
     * LocalDateTime转成Date
     * @return
     */
    public static Date convertDateByLocalDateTime(LocalDateTime localDateTime){
        try {
            //指定时区（如系统默认时区）
            ZoneId zoneId = ZoneId.systemDefault();
            //转换为 ZonedDateTime，再转为 Instant，最后生成 Date
            Date date = Date.from(localDateTime.atZone(zoneId).toInstant());
            return date;
        }catch (Exception e) {
            return null;
        }
    }
}
