package com.yd.common.utils;

import com.yd.common.constant.CodeGeneratorConstants;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;

/**
 * 编号生成工具类
 */
public class CodeGenerator {
    
    // 单例模式确保随机数生成器效率
    private static final Random random = new Random();
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyMMdd");

    /**
     * 生成编号
     * @param letter 首字母
     * @return 格式：首字母 + 6位日期（250903） + 7位随机数字
     */
    public static String generateCode(String letter) {
        //6位日期
        String datePart = LocalDateTime.now().format(DATE_FORMATTER);
        //7位随机数字
        String randomPart = generateRandomDigits(7);
        return letter + datePart + randomPart;
    }
    
    /**
     * 生成指定长度的随机数字字符串
     * @param length 数字字符串长度
     * @return 随机数字字符串
     */
    private static String generateRandomDigits(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("长度必须为正整数");
        }
        
        // 生成指定位数的随机数字
        int maxValue = (int) Math.pow(10, length);
        int randomNumber = random.nextInt(maxValue);
        
        // 格式化为固定长度，前面补零
        return String.format("%0" + length + "d", randomNumber);
    }

    public static void main(String[] args) {
        System.out.println(generateCode(CodeGeneratorConstants.APPOINTMENT));
    }
}
