package com.yd.common.result;

import lombok.Data;
import java.io.Serializable;

/**
 * 统一响应结果
 */
@Data
public class Result<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    private int code;
    private String msg;
    private T data;

    private Result() {}

    /**
     * 成功返回（不带上数据）
     */
    public static <T> Result<T> success() {
        Result<T> result = new Result<T>();
        result.setCode(200);
        result.setMsg("操作成功");
        return result;
    }

    /**
     * 成功返回（带上数据）
     */
    public static <T> Result<T> success(T data) {
        Result<T> result = new Result<T>();
        result.setCode(200);
        result.setMsg("操作成功");
        result.setData(data);
        return result;
    }

    /**
     * 失败返回
     */
    public static <T> Result<T> fail(int code, String msg) {
        Result<T> result = new Result<T>();
        result.setCode(code);
        result.setMsg(msg);
        return result;
    }

    /**
     * 失败返回
     */
    public static <T> Result<T> fail(String msg) {
        return fail(500, msg);
    }
}
