package com.yd.gateway.config;

import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 网关路由配置
 */
@Configuration
public class GatewayConfig {

    @Bean
    public RouteLocator customRouteLocator(RouteLocatorBuilder builder) {
        return builder.routes()
                // 认证服务路由
                .route("yd-auth-service", r -> r.path("/auth/**")
                        .uri("lb://yd-auth-service"))
                // 用户服务路由
                .route("yd-user-service", r -> r.path("/user/**")
                        .uri("lb://yd-user-service"))
                // SCRM服务路由
                .route("yd-scrm-service", r -> r.path("/scrm/**")
                        .uri("lb://yd-scrm-service"))
                .build();
    }
}
