package com.yd.feign.client.fallback;

import com.yd.common.entity.UserDetails;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.feign.client.UserFeignClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户服务Feign降级处理
 */
@Slf4j
@Component
public class UserFeignFallbackFactory implements FallbackFactory<UserFeignClient> {

    public UserFeignClient create(final Throwable cause) {
        return new UserFeignClient() {
            public Result<UserDetails> getByUsername(String username) {
                log.error("调用用户服务失败: {}", cause.getMessage());
                throw new BusinessException("获取用户信息失败，请稍后重试");
            }
        };
    }
}
