package com.yd.feign.client;

import com.yd.common.entity.UserDetails;
import com.yd.common.result.Result;
import com.yd.feign.client.fallback.UserFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户服务Feign客户端
 */
@FeignClient(name = "yd-user-service", fallbackFactory = UserFeignFallbackFactory.class)
public interface UserFeignClient {

    /**
     * 根据用户名获取用户信息
     */
    @GetMapping("/user/getByUsername")
    Result<UserDetails> getByUsername(@RequestParam("username") String username);
}
