package com.yd.auth.core.service;

import com.yd.auth.core.model.AuthUser;
import com.yd.user.api.dto.UserDTO;
import com.yd.user.api.feign.UserFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.stream.Collectors;

@Service
public class AuthUserDetailsService implements UserDetailsService {

    private final UserFeignClient userFeignClient;

    @Autowired
    public AuthUserDetailsService(UserFeignClient userFeignClient) {
        this.userFeignClient = userFeignClient;
    }

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        // 通过Feign调用yd-user服务获取用户信息
        UserDTO user = userFeignClient.findByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("用户不存在：" + username);
        }

        // 转换为Spring Security用户对象
        return new AuthUser(
                user.getId(),
                user.getUsername(),
                user.getPassword(),
                user.getRoles().stream()
                        .map(role -> new SimpleGrantedAuthority(role)) // 修正类名
                        .collect(Collectors.toList())
        );
    }
}
