/*
 * Decompiled with CFR 0.152.
 */
package com.yd.auth.core.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class JwtUtils {
    @Value(value="${jwt.secret}")
    private String secret;
    @Value(value="${jwt.expiration}")
    private Long expiration;
    @Value(value="${jwt.refresh-expiration}")
    private Long refreshExpiration;

    public String generateToken(UserDetails userDetails) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("roles", userDetails.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList()));
        return this.createToken(claims, userDetails.getUsername(), this.expiration);
    }

    public String generateRefreshToken(UserDetails userDetails) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        return this.createToken(claims, userDetails.getUsername(), this.refreshExpiration);
    }

    private String createToken(Map<String, Object> claims, String subject, Long expirationTime) {
        SecretKey key = Keys.hmacShaKeyFor((byte[])this.secret.getBytes(StandardCharsets.UTF_8));
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + expirationTime * 1000L)).signWith((Key)key, SignatureAlgorithm.HS256).compact();
    }

    public Claims parseToken(String token) {
        SecretKey key = Keys.hmacShaKeyFor((byte[])this.secret.getBytes(StandardCharsets.UTF_8));
        try {
            return (Claims)Jwts.parserBuilder().setSigningKey((Key)key).build().parseClaimsJws(token).getBody();
        }
        catch (ExpiredJwtException e) {
            throw new RuntimeException("\u4ee4\u724c\u5df2\u8fc7\u671f", e);
        }
        catch (UnsupportedJwtException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u4ee4\u724c", e);
        }
        catch (MalformedJwtException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u4ee4\u724c", e);
        }
        catch (SignatureException e) {
            throw new RuntimeException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("\u4ee4\u724c\u53c2\u6570\u9519\u8bef", e);
        }
    }

    public String getUsernameFromToken(String token) {
        return this.parseToken(token).getSubject();
    }

    public Date getExpirationDateFromToken(String token) {
        return this.parseToken(token).getExpiration();
    }

    public Boolean isTokenExpired(String token) {
        Date expiration = this.getExpirationDateFromToken(token);
        return expiration.before(new Date());
    }

    public Boolean validateToken(String token, UserDetails userDetails) {
        String username = this.getUsernameFromToken(token);
        return username.equals(userDetails.getUsername()) && this.isTokenExpired(token) == false;
    }

    public Boolean validateToken(String token) {
        try {
            Claims claims = this.parseToken(token);
            return this.isTokenExpired(token) == false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<String> getRolesFromToken(String token) {
        Claims claims = this.parseToken(token);
        return (List)claims.get("roles", List.class);
    }

    public <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.parseToken(token);
        return claimsResolver.apply(claims);
    }
}

