/*
 * Decompiled with CFR 0.152.
 */
package com.yd.gateway.filter;

import com.alibaba.fastjson.JSON;
import com.yd.auth.core.security.DummyAuthenticationManager;
import com.yd.auth.core.utils.JwtUtils;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import io.jsonwebtoken.Claims;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class AuthenticationFilter
extends AuthenticationWebFilter {
    private final JwtUtils jwtUtils;

    public AuthenticationFilter(JwtUtils jwtUtils) {
        super((ReactiveAuthenticationManager)new DummyAuthenticationManager());
        this.jwtUtils = jwtUtils;
        this.setServerAuthenticationConverter(this.jwtAuthenticationConverter());
    }

    private ServerAuthenticationConverter jwtAuthenticationConverter() {
        return exchange -> {
            ServerHttpRequest request = exchange.getRequest();
            String token = this.getTokenFromRequest(request);
            if (token == null) {
                return Mono.error((Throwable)new BusinessException("\u672a\u63d0\u4f9b\u4ee4\u724c"));
            }
            try {
                if (!this.jwtUtils.validateToken(token).booleanValue()) {
                    return Mono.error((Throwable)new BusinessException("\u65e0\u6548\u7684\u4ee4\u724c"));
                }
                Claims claims = this.jwtUtils.parseToken(token);
                String username = claims.getSubject();
                List roles = (List)claims.get((Object)"roles");
                List<Object> authorities = new ArrayList();
                if (roles != null && !roles.isEmpty()) {
                    authorities = roles.stream().map(role -> new SimpleGrantedAuthority("ROLE_" + role)).collect(Collectors.toList());
                }
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)username, null, authorities);
                return Mono.just((Object)authentication);
            }
            catch (Exception e) {
                return Mono.error((Throwable)new BusinessException(e.getMessage()));
            }
        };
    }

    private String getTokenFromRequest(ServerHttpRequest request) {
        String bearerToken = request.getHeaders().getFirst("Authorization");
        if (bearerToken != null && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        return null;
    }

    protected Mono<Void> onAuthenticationFailure(WebFilterExchange webFilterExchange, AuthenticationException exception) {
        ServerWebExchange exchange = webFilterExchange.getExchange();
        exchange.getResponse().setStatusCode(HttpStatus.UNAUTHORIZED);
        exchange.getResponse().getHeaders().setContentType(MediaType.APPLICATION_JSON);
        Result result = Result.fail((int)401, (String)exception.getMessage());
        byte[] bytes = JSON.toJSONString((Object)result).getBytes(StandardCharsets.UTF_8);
        DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(bytes);
        return exchange.getResponse().writeWith((Publisher)Mono.just((Object)buffer));
    }
}

