/*
 * Decompiled with CFR 0.152.
 */
package com.yd.auth.core.controller;

import com.yd.auth.core.service.AuthService;
import com.yd.common.result.Result;
import com.yd.user.service.entity.User;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthController {
    @Autowired
    private AuthService authService;

    @PostMapping(value={"/login"})
    public Result<?> login(@RequestBody Map<String, String> loginRequest) {
        String username = loginRequest.get("username");
        String password = loginRequest.get("password");
        Map<String, String> tokens = this.authService.login(username, password);
        return Result.success(tokens);
    }

    @PostMapping(value={"/refresh"})
    public Result<?> refreshToken(@RequestBody Map<String, String> refreshRequest) {
        String refreshToken = refreshRequest.get("refreshToken");
        Map<String, String> tokens = this.authService.refreshToken(refreshToken);
        return Result.success(tokens);
    }

    @PostMapping(value={"/register"})
    public Result<?> register(@RequestBody User user) {
        User registeredUser = this.authService.register(user);
        return Result.success((Object)registeredUser);
    }
}

