/*
 * Decompiled with CFR 0.152.
 */
package com.yd.gateway.config;

import com.yd.gateway.filter.AuthenticationFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.web.server.WebFilter;

@Configuration
@EnableWebFluxSecurity
public class GatewaySecurityConfig {
    private final AuthenticationFilter authenticationFilter;

    public GatewaySecurityConfig(AuthenticationFilter authenticationFilter) {
        this.authenticationFilter = authenticationFilter;
    }

    @Bean
    @Order(value=-1)
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        return ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.csrf().disable().securityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance()).authorizeExchange().pathMatchers(new String[]{"/auth/login", "/auth/refresh-token"})).permitAll().pathMatchers(new String[]{"/actuator/health/**"})).permitAll().anyExchange().authenticated().and().addFilterAt((WebFilter)this.authenticationFilter, SecurityWebFiltersOrder.AUTHENTICATION).build();
    }
}

