/*
 * Decompiled with CFR 0.152.
 */
package com.yd.framework.handler;

import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={BusinessException.class})
    public Result<?> handleBusinessException(BusinessException e) {
        log.error("\u4e1a\u52a1\u5f02\u5e38: {}", (Object)e.getMessage());
        return Result.fail((int)e.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<?> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        BindingResult bindingResult = e.getBindingResult();
        FieldError fieldError = bindingResult.getFieldError();
        String message = fieldError != null ? fieldError.getDefaultMessage() : "\u53c2\u6570\u6821\u9a8c\u5931\u8d25";
        log.error("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38: {}", (Object)message);
        return Result.fail((int)400, (String)message);
    }

    @ExceptionHandler(value={Exception.class})
    public Result<?> handleException(Exception e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38: ", (Throwable)e);
        return Result.fail((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }
}

